/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.config.templates;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.floragunn.codova.config.templates.AttributeSource;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.errors.InvalidExpression;
import com.floragunn.fluent.collections.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class PipeExpression {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private final String attributeName;
    private final ImmutableList<PipeFunction> functions;
    private final String source;

    PipeExpression(String attributeName, ImmutableList<PipeFunction> functions, String source) {
        this.attributeName = attributeName;
        this.functions = functions;
        this.source = "${" + source + "}";
    }

    public Object evaluate(Function<String, Object> valueResolver) {
        Object value = valueResolver.apply(this.attributeName);
        for (PipeFunction pipeFunction : this.functions) {
            value = pipeFunction.apply(value);
        }
        return value;
    }

    public Object evaluate(AttributeSource attributeSource) {
        Object value = attributeSource.getAttributeValue(this.attributeName);
        for (PipeFunction pipeFunction : this.functions) {
            value = pipeFunction.apply(value);
        }
        return value;
    }

    public String toString() {
        return this.source;
    }

    public static PipeExpression parse(String string) throws ConfigValidationException {
        return PipeExpression.parse(string, 0);
    }

    public static PipeExpression parse(String string, int start) throws ConfigValidationException {
        return new Parser(string, start).parse();
    }

    private static Object toLowerCase(Object value) {
        if (value instanceof String) {
            return ((String)value).toLowerCase();
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(v -> PipeExpression.toLowerCase(v)).collect(Collectors.toList());
        }
        return value;
    }

    private static Object toUpperCase(Object value) {
        if (value instanceof String) {
            return ((String)value).toUpperCase();
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(v -> PipeExpression.toUpperCase(v)).collect(Collectors.toList());
        }
        return value;
    }

    private static String toRegexFragment(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            StringBuilder result = new StringBuilder("(");
            boolean first = true;
            for (Object element : (Collection)value) {
                if (element == null) continue;
                if (!first) {
                    result.append("|");
                } else {
                    first = false;
                }
                result.append(Pattern.quote(element.toString()));
            }
            result.append(")");
            return result.toString();
        }
        return "(" + Pattern.quote(value.toString()) + ")";
    }

    private static List<?> tail(Collection<?> collection) {
        if (collection.size() <= 1) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(collection.size() - 1);
        Iterator<?> iter = collection.iterator();
        iter.next();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    public static class Parser {
        private final String string;
        private int i;
        private int start;
        private boolean expectTerminationCharacter = false;

        public Parser(String string, int start) {
            this.string = string;
            this.i = start;
            this.start = start;
        }

        public PipeExpression parse() throws ConfigValidationException {
            ImmutableList.Builder functions;
            String attributeName;
            block8: {
                int openBracket = this.i;
                attributeName = this.readAttributeName(openBracket);
                functions = new ImmutableList.Builder();
                this.skipSpaces();
                while (true) {
                    char c2;
                    if (this.i >= this.string.length()) {
                        if (this.expectTerminationCharacter) {
                            throw new ConfigValidationException(this.error("Unterminated expression").column(openBracket));
                        }
                        break block8;
                    }
                    char c = this.string.charAt(this.i);
                    char c3 = c2 = this.i < this.string.length() - 1 ? this.string.charAt(this.i + 1) : (char)'\u0000';
                    if (c == '|') {
                        this.skipSpaces();
                        int functionStart = ++this.i;
                        String functionName = this.readFunctionName(openBracket);
                        functions.with((Object)PipeFunction.get(functionName, functionStart));
                        continue;
                    }
                    if (c == '?' && c2 == ':') {
                        this.i += 2;
                        this.skipSpaces();
                        Object defaultValue = this.readJson(this.i);
                        functions.with(v -> v != null ? v : defaultValue);
                        continue;
                    }
                    if (c == ':' && c2 == '-') {
                        this.i += 2;
                        int closeBracket = this.string.indexOf(125, this.i);
                        if (closeBracket == -1) {
                            throw new ConfigValidationException(this.error("Unterminated expression").column(openBracket));
                        }
                        String defaultValue = this.string.substring(this.i, closeBracket);
                        functions.with(v -> v != null ? v : defaultValue);
                        this.i = closeBracket;
                        continue;
                    }
                    if (c == '}') {
                        ++this.i;
                        break block8;
                    }
                    if (!Character.isWhitespace(c)) break;
                    this.skipSpaces();
                }
                throw new ConfigValidationException(this.error("Unexpected character in expression").column(this.i));
            }
            String source = this.string.substring(this.start, this.i - 1);
            return new PipeExpression(attributeName, (ImmutableList<PipeFunction>)functions.build(), source);
        }

        public int getParsePosition() {
            return this.i;
        }

        Parser expectTerminationCharacter() {
            this.expectTerminationCharacter = true;
            return this;
        }

        private String readAttributeName(int openBracket) throws ConfigValidationException {
            while (true) {
                if (this.i >= this.string.length()) {
                    if (this.expectTerminationCharacter) {
                        throw new ConfigValidationException(this.error("Unterminated expression").column(openBracket));
                    }
                    return this.string.substring(openBracket, this.i);
                }
                char c = this.string.charAt(this.i);
                if (!Character.isLetter(c) && !Character.isDigit(c) && c != '.' && c != '_') {
                    String attributeName = this.string.substring(openBracket, this.i);
                    return attributeName;
                }
                ++this.i;
            }
        }

        private String readFunctionName(int openBracket) throws ConfigValidationException {
            int functionStart = this.i;
            this.i += 2;
            while (true) {
                if (this.i >= this.string.length()) {
                    if (this.expectTerminationCharacter) {
                        throw new ConfigValidationException(this.error("Unterminated expression").column(openBracket));
                    }
                    return this.string.substring(functionStart, this.i);
                }
                char c = this.string.charAt(this.i);
                if (!Character.isLetter(c)) {
                    String functionName = this.string.substring(functionStart, this.i);
                    return functionName;
                }
                ++this.i;
            }
        }

        private void skipSpaces() {
            while (this.i < this.string.length() && Character.isSpaceChar(this.string.charAt(this.i))) {
                ++this.i;
            }
        }

        private Object readJson(int start) throws ConfigValidationException {
            try {
                JsonParser parser = JSON_FACTORY.createParser(this.string.substring(start));
                Object result = new DocReader(Format.JSON, parser).read();
                this.i = start + (int)parser.getTokenLocation().getCharOffset() + parser.getLastClearedToken().asString().length();
                return result;
            }
            catch (DocumentParseException | IOException e) {
                throw new ConfigValidationException(this.error("Expression contains invalid JSON").column(start));
            }
        }

        private InvalidExpression error(String message) {
            return new InvalidExpression(null, this.string).message(message).column(this.i);
        }
    }

    @FunctionalInterface
    static interface PipeFunction {
        public Object apply(Object var1);

        public static PipeFunction get(String operation, int stateStart) throws ConfigValidationException {
            if (operation.equals("toString")) {
                return v -> v != null ? v.toString() : "null";
            }
            if (operation.equals("toJson")) {
                return v -> v != null ? DocWriter.json().writeAsString(v) : null;
            }
            if (operation.equals("toList")) {
                return v -> v instanceof Collection ? v : Collections.singletonList(v);
            }
            if (operation.equals("head")) {
                return v -> v instanceof Collection ? Iterables.getFirst((Iterable)((Collection)v), null) : v;
            }
            if (operation.equals("tail")) {
                return v -> v instanceof Collection ? PipeExpression.tail((Collection)v) : Collections.emptyList();
            }
            if (operation.equals("toRegexFragment")) {
                return v -> PipeExpression.toRegexFragment(v);
            }
            if (operation.equals("toLowerCase")) {
                return v -> PipeExpression.toLowerCase(v);
            }
            if (operation.equals("toUpperCase")) {
                return v -> PipeExpression.toUpperCase(v);
            }
            throw new ConfigValidationException(new InvalidExpression(null, operation).message("Unsupported operation").column(stateStart).expected("toString|toJson|head|tail|toRegexFragment|toLowerCase|toUpperCase"));
        }
    }
}

